/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.data.VanillaMaxLevel;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class FireProtectionModifier
extends IncrementalModifier {
    private static final TinkerDataCapability.TinkerDataKey<FireData> FIRE_DATA = TConstruct.createKey("fire_protection");

    public FireProtectionModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEvent.LivingUpdateEvent.class, FireProtectionModifier::livingTick);
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (!source.m_19379_() && !source.m_19378_() && source.m_19384_()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.0f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.0f, tooltip);
    }

    private int getEnchantmentLevel(EquipmentChangeContext context, EquipmentSlot slotType) {
        if (context.getToolInSlot(slotType) == null) {
            return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44966_, (ItemStack)context.getEntity().m_6844_(slotType));
        }
        return 0;
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR && !entity.f_19853_.f_46443_) {
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null) {
                    fireData.modifier.set(slot, 0.0f);
                    if (fireData.modifier.getMax() == 0.0f) {
                        data.remove(FIRE_DATA);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (!entity.f_19853_.f_46443_ && slot.m_20743_() == EquipmentSlot.Type.ARMOR && !tool.isBroken()) {
            float scaledLevel = this.getScaledLevel(tool, level);
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData == null) {
                    fireData = new FireData();
                    for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                        fireData.vanilla.set(slotType, this.getEnchantmentLevel(context, slotType));
                    }
                    int fireTimer = entity.m_20094_();
                    if (fireTimer > 0) {
                        fireData.finish = entity.f_19797_ + fireTimer + 1;
                    }
                    data.put(FIRE_DATA, fireData);
                }
                fireData.modifier.set(slot, scaledLevel);
                fireData.vanilla.set(slot, 0);
            });
        }
    }

    @Override
    public void onEquipmentChange(IToolStackView tool, int level, EquipmentChangeContext context, EquipmentSlot slotType) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (!entity.f_19853_.f_46443_ && slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null && fireData.modifier.getMaxSlot() == slotType) {
                    fireData.vanilla.set(slot, this.getEnchantmentLevel(context, slot));
                }
            });
        }
    }

    private static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.f_19853_.f_46443_ && !entity.m_5833_()) {
            entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                float maxLevel;
                int maxVanilla;
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null && (float)(maxVanilla = fireData.vanilla.getMax()) < (maxLevel = fireData.modifier.getMax())) {
                    int currentFire = entity.m_20094_();
                    if (currentFire <= 0) {
                        if (fireData.finish > entity.f_19797_) {
                            fireData.finish = 0;
                        }
                    } else if (currentFire + entity.f_19797_ > fireData.finish) {
                        int newFire = currentFire;
                        newFire = maxVanilla > 0 ? (newFire -= Mth.m_14143_((float)((float)currentFire / (1.0f - (float)maxVanilla * 0.15f) * (maxLevel - (float)maxVanilla) * 0.15f))) : (newFire -= Mth.m_14143_((float)((float)currentFire * maxLevel * 0.15f)));
                        if (newFire < 0) {
                            newFire = 0;
                            fireData.finish = 0;
                        } else {
                            fireData.finish = newFire + entity.f_19797_ + 1;
                        }
                        entity.m_7311_(newFire);
                    }
                }
            });
        }
    }

    protected static class FireData {
        public final ModifierMaxLevel modifier = new ModifierMaxLevel();
        public final VanillaMaxLevel vanilla = new VanillaMaxLevel();
        int finish = 0;

        protected FireData() {
        }
    }
}

